<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class CheckInstalled
{
    public function handle(Request $request, Closure $next)
    {
        if (!$this->isInstalled() && !$request->is('install*')) {
            return redirect('/install');
        }
        
        if ($this->isInstalled() && $request->is('install*')) {
            return redirect('/');
        }
        
        return $next($request);
    }
    
    private function isInstalled()
    {
        return File::exists(storage_path('app/installed.txt'));
    }
}